/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.jffi.AsmRuntime;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jaffl.provider.jffi.NumberUtil;
import com.kenai.jaffl.provider.jffi.SkinnyMethodAdapter;
import com.kenai.jaffl.struct.Struct;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import org.python.objectweb.asm.ClassVisitor;
import org.python.objectweb.asm.MethodVisitor;

class AsmUtil {
    private AsmUtil() {
    }

    public static final MethodVisitor newTraceMethodVisitor(MethodVisitor methodVisitor) {
        try {
            Class<?> clazz = Class.forName("org.python.objectweb.asm.util.TraceMethodVisitor");
            Constructor<?> constructor = clazz.getDeclaredConstructor(MethodVisitor.class);
            return (MethodVisitor)constructor.newInstance(methodVisitor);
        }
        catch (Throwable throwable) {
            return methodVisitor;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor classVisitor, OutputStream outputStream) {
        return AsmUtil.newTraceClassVisitor(classVisitor, new PrintWriter(outputStream, true));
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor classVisitor, PrintWriter printWriter) {
        try {
            Class<?> clazz = Class.forName("org.python.objectweb.asm.util.TraceClassVisitor");
            Constructor<?> constructor = clazz.getDeclaredConstructor(ClassVisitor.class, PrintWriter.class);
            return (ClassVisitor)constructor.newInstance(classVisitor, printWriter);
        }
        catch (Throwable throwable) {
            return classVisitor;
        }
    }

    public static final ClassVisitor newCheckClassAdapter(ClassVisitor classVisitor) {
        try {
            Class<?> clazz = Class.forName("org.python.objectweb.asm.util.CheckClassAdapter");
            Constructor<?> constructor = clazz.getDeclaredConstructor(ClassVisitor.class);
            return (ClassVisitor)constructor.newInstance(classVisitor);
        }
        catch (Throwable throwable) {
            return classVisitor;
        }
    }

    public static final Class unboxedReturnType(Class clazz) {
        if (Pointer.class.isAssignableFrom(clazz) || Struct.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
            return Platform.getPlatform().longSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return AsmUtil.unboxedType(clazz);
    }

    public static final Class unboxedType(Class clazz) {
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == NativeLong.class) {
            return Platform.getPlatform().longSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        if (Pointer.class.isAssignableFrom(clazz) || Struct.class.isAssignableFrom(clazz)) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return clazz;
    }

    public static final Class boxedType(Class clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    static final void emitReturnOp(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz) {
        if (!clazz.isPrimitive()) {
            skinnyMethodAdapter.areturn();
        } else if (Long.TYPE == clazz) {
            skinnyMethodAdapter.lreturn();
        } else if (Float.TYPE == clazz) {
            skinnyMethodAdapter.freturn();
        } else if (Double.TYPE == clazz) {
            skinnyMethodAdapter.dreturn();
        } else if (Void.TYPE == clazz) {
            skinnyMethodAdapter.voidreturn();
        } else {
            skinnyMethodAdapter.ireturn();
        }
    }

    static final int calculateLocalVariableSpace(Class clazz) {
        return Long.TYPE == clazz || Double.TYPE == clazz ? 2 : 1;
    }

    static final int calculateLocalVariableSpace(Class ... classArray) {
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            n += AsmUtil.calculateLocalVariableSpace(classArray[i]);
        }
        return n;
    }

    private static final void unboxPointerOrStruct(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, Class clazz2) {
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(AsmRuntime.class), Long.TYPE == clazz2 ? "longValue" : "intValue", CodegenUtils.sig(clazz2, clazz));
    }

    static final void unboxPointer(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz) {
        AsmUtil.unboxPointerOrStruct(skinnyMethodAdapter, Pointer.class, clazz);
    }

    static final void unboxStruct(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz) {
        AsmUtil.unboxPointerOrStruct(skinnyMethodAdapter, Struct.class, clazz);
    }

    static final void unboxNumber(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, Class clazz2) {
        String string;
        String string2 = Long.TYPE == clazz2 ? "longValue" : "intValue";
        String string3 = string = Long.TYPE == clazz2 ? "()J" : "()I";
        if (Byte.class == clazz || Short.class == clazz || Integer.class == clazz) {
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(clazz), string2, string);
        } else if (Long.class == clazz) {
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(clazz), "longValue", "()J");
        } else if (Float.class == clazz) {
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(clazz), "floatValue", "()F");
        } else if (Double.class == clazz) {
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(clazz), "doubleValue", "()D");
        } else if (NativeLong.class.isAssignableFrom(clazz)) {
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(clazz), string2, string);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(clazz), "booleanValue", "()Z");
            NumberUtil.widen(skinnyMethodAdapter, Boolean.TYPE, clazz2);
        } else {
            throw new IllegalArgumentException("unsupported Number subclass: " + clazz);
        }
    }
}

